﻿<%@ Control Language="C#" %>
<%@ Import Namespace="Kesion.Publics" %>
<%@ Import Namespace="Kesion.BLL" %>
<%@ Import Namespace="Kesion.Cache" %>
<%@ Import Namespace="Kesion.HtmlTags" %>
<%@ Import Namespace="Kesion.APPCode" %>
<%@ Import Namespace="Kesion.Controllers" %>
<%@ Import Namespace="System.Data" %>

<script runat="server" type="text/C#">
    dynamic __user = HttpContext.Current.Items["user"];
    private static dynamic __info = new System.Dynamic.ExpandoObject();   //初始化当前页信息
    bool isLoadPage = true;  //定义页面是否加载
    private int showType = 0;       //快速查看类型
    //public static int IsFaHuo = 0;
    protected void Page_Load(object sender, EventArgs e)
    {
        showType = Utils.StrToInt(KSCMS.S("showtype"));
    }

    protected string GetCourseType(int cosType)
    {
        #region 课程类型名称
        string typeName = string.Empty;
        switch (cosType)
        {
            case 1:
                typeName = "直播课程";
                break;
            case 2:
                typeName = "面授课程";
                break;
            default:
                typeName = "点播课程";
                break;
        }
        return typeName;
        #endregion
    }
    public string GetCourseUrl(int cosType, int courseId)
    {
        #region 课程链接
        string courseUrl = string.Empty;

        switch (cosType)
        {
            case 1:
                courseUrl = BaseFun.GetRewriteUrl("liveview", courseId);
                break;
            case 2:
                courseUrl = BaseFun.GetRewriteUrl("faceview", courseId);
                break;
            default:
                courseUrl = BaseFun.GetRewriteUrl("courseview", courseId);
                break;
        }
        return courseUrl;
        #endregion
    }

    public string GetCollageStatus(int totalNum, int collageNum, DateTime endDate)
    {
        #region 拼团状态
        string str = string.Empty;
        if(totalNum == collageNum)
        {
            str = "<span style='color:green'>拼团成功</span>";
        }
        else
        {
            if(Utils.DateDiff(Utils.DateInterval.Minute, DateTime.Now, endDate) > 0)
            {
                str = "<span style='color:orange'>组团进行中</span>";
            }
            else
            {
                str = "<span style='color:red'>拼团失败</span>";
            }
        }
        return str;
        #endregion
    }
</script>
<%
    if (!isLoadPage) return;
%>
<style>
    .cartbox .kb_box { border: 1px dashed #f7d6b2; margin-top: 10px; text-align: left; padding: 0px 15px 0px 35px; line-height: 40px; font-size: 12px; background: #fefaf5 url(../yes.png) no-repeat 10px 50%;}
    .cartbox .kb_box b { color: #f60; padding-left: 10px;}
    .cartbox .kb_box em { text-decoration: line-through; color: #999;}
    .cartbox .kb_box span { float: right}
    .cartbox .kb_box a { font-size: 14px;}
    .cartbox .kb_box a:hover { color: #666; }
    .cartbox .kb_box:after { content: "."; display: block; height: 0; clear: both; visibility: hidden}
</style>
<div class="r_tybox nomar t_tybox nomar disting ">
    <div class="r_title">
        <h4 class="disting-title">我的拼团</h4>
        <div class="tabs">
            <ul>
                <%if (BaseFun.CheckModulePower("edu")){%><li><a href="<%=BasicField.GetUserUrl("Course/MyCourseOrder") %>">课程订单</a></li> <%} %>
                <%if (BaseFun.CheckModulePower("mall")){%><li><a href="<%=BasicField.GetUserUrl("Shop/myorder") %>">商城订单</a></li><%} %>
                <%if (Kesion.Cache.CommonJsonCache.CheckYunAPPHasAllow("Plus.Collage")){%><li class="puton"><a href="<%=BasicField.GetUserUrl("Course/MyCourseCollage") %>">我的拼团</a></li><%} %>
                <%if (Kesion.Cache.CommonJsonCache.CheckYunAPPHasAllow("Plus.CourseBargain")){%><li><a href="<%=BasicField.GetUserUrl("course/mybargain") %>">我的砍价</a></li><%} %>
                <%if (BaseFun.CheckModulePower("exam")){%><li style="display: none"><a href="<%=BasicField.GetUserUrl("exam/mysjclass") %>">考试分类</a></li><%} %>
            </ul>
        </div>
    </div>

    <div class="top-sort clearfix">
        <div class="top-sort-tab ">
            <ul>
                <li <%=showType==0?" class='puton'":"" %>><a href="<%=BasicField.GetUserUrl("course/MyCourseCollage") %>">全部拼团</a></li>
                <li <%=showType==1?" class='puton'":"" %>><a href="<%=BasicField.GetUserUrl("course/MyCourseCollage","showtype-1") %>">进行中</a></li>
                <li <%=showType==2?" class='puton'":"" %>><a href="<%=BasicField.GetUserUrl("course/MyCourseCollage","showtype-2") %>">已成功</a></li>
                <li <%=showType==3?" class='puton'":"" %>><a href="<%=BasicField.GetUserUrl("course/MyCourseCollage","showtype-3") %>">未成功</a></li>
            </ul>
        </div>
    </div>
    <input type="hidden" name="action" value="del" />
    <div class="courseOrder">
        <ul id="orderlist">
            <%
                StringBuilder sb = new StringBuilder();
                int recordcount, pagecount;
                int CurrPage = new BasicField().GetCurrPage;    //当前页码
                int PageSize = 10;      //每页数据量
                string sqlParam = " WHERE UserType = 1 AND Status != 0 AND OrderId IN (SELECT OrderId FROM KS_CosCollageDetail WHERE UserId = " + new TemporaryVar().UserID + ")";

                if (showType > 0)
                {
                    switch (showType)
                    {
                        case 1:
                            sqlParam += " AND TotalNum <> CollageNum AND EndDate > '" + DateTime.Now + "'";
                            break;
                        case 2:
                            sqlParam += " AND TotalNum = CollageNum ";
                            break;
                        case 3:
                            sqlParam += " AND TotalNum <> CollageNum AND EndDate <= '" + DateTime.Now + "'";
                            break;
                    }
                }
                using (DataTable dt = DataFactory.GetPage("*", "KS_CosCollageDetail" + sqlParam, "ID", "ORDER BY ID DESC", CurrPage, PageSize, out recordcount, out pagecount))
                {
                    if (dt.Rows.Count > 0)
                    {
                        foreach (DataRow dr in dt.Rows)
                        {
                            sb.AppendLine("<li>");
                            sb.AppendLine("<span>" + GetCollageStatus(Utils.StrToInt(dr["TotalNum"].ToString()), Utils.StrToInt(dr["CollageNum"].ToString()), Utils.StrToDateTime(dr["EndDate"].ToString())) + "</span>");
                            sb.AppendLine("<div>");
                            #region 内层
                            sb.AppendLine("<div class=\"course\">");
                            
                            using (var dr2 = DataFactory.ExecuteReader("SELECT * FROM KS_CosCollageDetail WHERE UserId = " + new TemporaryVar().UserID + " AND OrderId = '" + dr["OrderId"].ToString() + "'"))
                            {
                                while(dr2.Read())
                                {
                                    sb.AppendLine("<div class=\"loop\">");
                                    sb.AppendLine("<div class=\"image\"><img src=\"" + dr2["PictureUrl"].ToString() + "\" onerror=\"this.src='/sysimg/user/10/nopic_200_120.png'\" alt=\"" + dr2["CName"].ToString() + " \" /></div>");
                                    sb.AppendLine("<div class=\"title\"><a href=\"" + GetCourseUrl(Utils.StrToInt(dr2["CourseType"]), Utils.StrToInt(dr2["CourseId"])) + "\" title=\"" + dr2["CName"].ToString() + "\" target=\"_blank\">" + dr2["CName"].ToString() + "</a></div>");
                                    sb.AppendLine("<div class=\"type\">" + GetCourseType(Utils.StrToInt(dr2["CourseType"].ToString())) + "</div>");
                                    decimal orderPrice = Utils.StrToDecimal(dr2["OrderPrice"].ToString());  //付款价格
                                    decimal price = Utils.StrToDecimal(dr["Price"].ToString());     //原价
                                    decimal favorablePrice = price - orderPrice;        //优惠价格
                                    sb.AppendLine("<div>" + dr["TotalNum"].ToString() + "人团,拼团价：<span style='color:red'> ¥ " + Kesion.APPCode.Public.ReturnShopPrice(orderPrice) + "</span>  单购价：¥ " + Kesion.APPCode.Public.ReturnShopPrice(price) + ",组团购买省 ¥ " + Kesion.APPCode.Public.ReturnShopPrice(favorablePrice) + " </div>");
                                    sb.AppendLine("</div>");
                                }
                                dr2.Close();
                            }
                            sb.AppendLine("</div>");
                            #endregion
                            sb.AppendLine("<div class=\"operating\"><div class=\"fr\">");
                            sb.AppendLine("<div class=\"button\"><a href=\"" + BaseFun.GetRewriteUrl("collage","a-showcollage/coursetype-" + dr["CourseType"].ToString() + "/courseid-" + dr["CourseId"].ToString() + "/usertype-" + dr["UserType"].ToString() + "/orderid-" + dr["OrderId"].ToString() + "\"") + "\">拼团订单详情</a></div>");
                            sb.AppendLine("</li>");
                        }
                    }
                    else
                    {
                        sb.AppendLine(" <div class=\"empty\">没有找到订单信息</div><style>.cz_btn{display:none;}</style>");
                    }
                }
                KSCMS.W(sb.ToString());
            %>
        </ul>

        <div class="cz_btn">
            <div class="f-left">
                <%  #region 分页
                   string PageStr=__user.GroupID==3||__user.GroupID==4?"[KS:PageStr1]": "[KS:PageStr2]";
                    BasicField.ReplaceFilterPage(ref PageStr, CurrPage, PageSize, pagecount, recordcount);
                    KSCMS.W(PageStr);
                    #endregion
                %>
            </div>
            <div class="f-right">
            </div>
            <div class="clear"></div>
        </div>

    </div>
    <script>
        $(function () {
            $(".courseOrder li:first").addClass("noBorderTop");
        });
    </script>

</div>

